#----------------------------------------------------#
# This script runs every game tick.
# All the map specific commands are called from here.
#
# Scripter: Liontack
# Called by tag: #main:tick
#----------------------------------------------------#



# Load in the islands when needed
function main:tick_load_islands

# Opening cage when arrows hits lock
execute as @e[tag=cage_door, tag=!door_opened] at @s positioned ^0.8125 ^-0.9375 ^ if entity @e[type=arrow, distance=..0.14] run function main:open_cage

# Remember player path
execute as @e[type=player, nbt={playerGameType:2}] at @s positioned ~ ~1.5 ~ unless entity @e[type=marker, tag=location_marker, scores={player_location_age=1}, distance=..0.2] run function main:remember_player_location

# Keep track of the number of saved allay
execute store result score allays_freed var run execute if entity @e[type=allay, tag=free]
bossbar set fourth name [{"color":"black", "text":"Allay's Saved: "}, {"score":{"name":"allays_freed","objective":"var"}}, {"text":"/16"}]

# Handle checkpoints
execute as @e[type=block_display, tag=!pressed_down] at @s positioned ~0.125 ~ ~0.125 if entity @e[type=player, dx=0.75, dy=0.1, dz=0.75] run function main:activate_checkpoint
execute as @e[type=block_display, tag=pressed_down] at @s positioned ~0.125 ~ ~0.125 unless entity @e[type=player, dx=0.75, dy=0.1, dz=0.75] run function main:deactivate_checkpoint

# Keep player xp on 0
xp set @a 0 levels
xp set @a 0 points

# Open end portal when needed
execute if entity @e[type=player, x=449, y=56, z=364, dx=4, dy=6, dz=4] run fill 450 55 365 452 60 367 air

# Bossbar visibilty
tag @p remove see_bossbars
execute as @p if entity @s[nbt={SelectedItem:{id:"minecraft:spruce_hanging_sign"}}] run tag @p add see_bossbars
execute as @p if data entity @p Inventory[{Slot: -106b, id:"minecraft:spruce_hanging_sign"}] run tag @p add see_bossbars
execute if entity @e[tag=see_bossbars] run bossbar set top visible true
execute if entity @e[tag=see_bossbars] run bossbar set second visible true
execute if entity @e[tag=see_bossbars] run bossbar set third visible true
execute if entity @e[tag=see_bossbars] run bossbar set fourth visible true
execute unless entity @e[tag=see_bossbars] run bossbar set top visible false
execute unless entity @e[tag=see_bossbars] run bossbar set second visible false
execute unless entity @e[tag=see_bossbars] run bossbar set third visible false
execute unless entity @e[tag=see_bossbars] run bossbar set fourth visible false

# Update bossbars
function main:update_bossbars

# Reset fallen player
execute as @e[type=player] at @s if block ~ ~-1 ~ air run scoreboard players add @s air_time 1
execute as @e[type=player] at @s unless block ~ ~-1 ~ air run scoreboard players reset @s air_time
execute as @e[type=player, nbt={OnGround:1b}] run scoreboard players reset @s air_time
execute as @e[type=player, nbt={playerGameType:2}, scores={air_time=30}] run title @s title {"text":"\ue101"}
execute as @e[type=player, nbt={playerGameType:2}, scores={air_time=40..}] run function main:save_fallen_player
execute as @e[type=player, nbt={playerGameType:2}] at @s if block ~ ~ ~ lava run title @s title {"text":"\ue101"}
execute as @e[type=player, nbt={playerGameType:2}] at @s if block ~ ~ ~ lava run function main:save_fallen_player

# Let allay's follow the player
teleport @e[tag=follow_player_path_1] @e[tag=location_marker, scores={player_location_age=10}, limit=1]
teleport @e[tag=follow_player_path_2] @e[tag=location_marker, scores={player_location_age=15}, limit=1]
teleport @e[tag=follow_player_path_3] @e[tag=location_marker, scores={player_location_age=20}, limit=1]
teleport @e[tag=follow_player_path_4] @e[tag=location_marker, scores={player_location_age=25}, limit=1]
teleport @e[tag=follow_player_path_5] @e[tag=location_marker, scores={player_location_age=30}, limit=1]
teleport @e[tag=follow_player_path_6] @e[tag=location_marker, scores={player_location_age=35}, limit=1]
teleport @e[tag=follow_player_path_7] @e[tag=location_marker, scores={player_location_age=40}, limit=1]
teleport @e[tag=follow_player_path_8] @e[tag=location_marker, scores={player_location_age=45}, limit=1]
teleport @e[tag=follow_player_path_9] @e[tag=location_marker, scores={player_location_age=50}, limit=1]
teleport @e[tag=follow_player_path_10] @e[tag=location_marker, scores={player_location_age=55}, limit=1]
teleport @e[tag=follow_player_path_11] @e[tag=location_marker, scores={player_location_age=60}, limit=1]
teleport @e[tag=follow_player_path_12] @e[tag=location_marker, scores={player_location_age=65}, limit=1]
teleport @e[tag=follow_player_path_13] @e[tag=location_marker, scores={player_location_age=70}, limit=1]
teleport @e[tag=follow_player_path_14] @e[tag=location_marker, scores={player_location_age=75}, limit=1]
teleport @e[tag=follow_player_path_15] @e[tag=location_marker, scores={player_location_age=80}, limit=1]
teleport @e[tag=follow_player_path_16] @e[tag=location_marker, scores={player_location_age=85}, limit=1]

execute as @e[tag=follow_player_path_1] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=9}, limit=1]
execute as @e[tag=follow_player_path_2] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=14}, limit=1]
execute as @e[tag=follow_player_path_3] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=19}, limit=1]
execute as @e[tag=follow_player_path_4] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=24}, limit=1]
execute as @e[tag=follow_player_path_5] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=29}, limit=1]
execute as @e[tag=follow_player_path_6] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=34}, limit=1]
execute as @e[tag=follow_player_path_7] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=39}, limit=1]
execute as @e[tag=follow_player_path_8] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=44}, limit=1]
execute as @e[tag=follow_player_path_9] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=49}, limit=1]
execute as @e[tag=follow_player_path_10] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=54}, limit=1]
execute as @e[tag=follow_player_path_11] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=59}, limit=1]
execute as @e[tag=follow_player_path_12] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=64}, limit=1]
execute as @e[tag=follow_player_path_13] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=69}, limit=1]
execute as @e[tag=follow_player_path_14] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=74}, limit=1]
execute as @e[tag=follow_player_path_15] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=79}, limit=1]
execute as @e[tag=follow_player_path_16] at @s run teleport @s ~ ~ ~ facing entity @e[tag=location_marker, scores={player_location_age=84}, limit=1]

# At speech 0, also reset bossbar
execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run title @p times 10 20 10
execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run team join nopush @p

execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run bossbar set top players
execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run bossbar set top players
execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run bossbar set top players
execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run bossbar set top players

execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run bossbar set top players @a
execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run bossbar set second players @a
execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run bossbar set third players @a
execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run bossbar set fourth players @a

# Text and speech of info
execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run execute as @a run playsound info.1 voice @s ~ ~ ~ 100
execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run tellraw @a {"text":"Your adventure starts when you walk through the stone arch."}
execute at @a if entity @e[tag=spawn_location, distance=1.5..] if score info var matches 0 run scoreboard players add info var 1

execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_1_1] if score info var matches 1 run stopsound @a
execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_1_1] if score info var matches 1 run execute as @a run playsound info.2 voice @s ~ ~ ~ 100
execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_1_1] if score info var matches 1 run tellraw @a {"text":"Just like you can't see what the future holds, you can only see a little part of your path ahead."}
execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_1_1] if score info var matches 1 run scoreboard players add info var 1

execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_1_3] if score info var matches 2 run stopsound @a
execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_1_3] if score info var matches 2 run execute as @a run playsound info.3 voice @s ~ ~ ~ 100
execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_1_3] if score info var matches 2 run tellraw @a {"text":"Feel free to punch any mob out of your way."}
execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_1_3] if score info var matches 2 run scoreboard players add info var 1

execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_1_5] if score info var matches 3 run stopsound @a
execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_1_5] if score info var matches 3 run execute as @a run playsound info.4 voice @s ~ ~ ~ 100
execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_1_5] if score info var matches 3 run tellraw @a {"text":"If you hit the lock on a cage with a strong arrow it will break open."}
execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_1_5] if score info var matches 3 run scoreboard players add info var 1

execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_2_1] if score info var matches 4 run stopsound @a
execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_2_1] if score info var matches 4 run execute as @a run playsound info.5 voice @s ~ ~ ~ 100
execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_2_1] if score info var matches 4 run tellraw @a {"text":"That is everything I needed to tell you, enjoy the adventure!"}
execute at @p as @e[tag=island_center, limit=1, sort=nearest, distance=..6.0] if entity @s[tag=island_center_2_1] if score info var matches 4 run scoreboard players add info var 1

# Register finishing player
execute at @a if block ~ ~ ~ heavy_weighted_pressure_plate if score finished var matches 0 run execute as @a run playsound info.6 voice @s ~ ~ ~ 100
execute at @a if block ~ ~ ~ heavy_weighted_pressure_plate if score finished var matches 0 run tellraw @a {"text":"You reached the end of your adventure. Congratulations."}
execute at @a if block ~ ~ ~ heavy_weighted_pressure_plate if score finished var matches 0 run scoreboard players set finished var 1
